/* --------------------------- INTUIT CONFIDENTIAL ---------------------------

	utils.js

	Written by		Date 
	
	Revised by		Date		Summary of changes
	Jason Harris	11/11/08	Added methods to handle enabling/disabling elements.
	Lane Roathe		06/22/10	[DE1411] check window.viewController usage to fix deferred printing
								(Some reports do not have a viewController or attached method)
	Lane Roathe		08/30/10	[S692] Add export button

	Copyright 2008-2010 Intuit, Inc All rights reserved. Unauthorized
	reproduction is a violation of applicable law. This material contains
	certain confidential and proprietary information and trade secrets of
	Intuit, Inc.
		
	RESTRICTED RIGHTS LEGEND
		
	Use, duplication, or disclosure by the Government is subject to
	restrictions as set forth in subdivision (b) (3) (ii) of the Rights in
	Technical Data and Computer Software clause at 52.227-7013.
		
	Intuit, Inc
	P.O. Box 7850
	Mountain View, CA 94039-7850

----------------------------- INTUIT CONFIDENTIAL ------------------------- */

function deepCopy(obj){
	var seenObjects = [];
	var mappingArray = [];
	var	f = function(simpleObject) {
		var indexOf = seenObjects.indexOf(simpleObject);
		if (indexOf == -1) {			
			if(simpleObject instanceof Array) {
				seenObjects.push(simpleObject);
				var newArray = [];
				mappingArray.push(newArray);
				for(var i=0,len=simpleObject.length; i<len; i++)
					newArray.push(f(simpleObject[i]));
				return newArray;
			} else if(typeof simpleObject == 'object' && simpleObject !== null) {
				seenObjects.push(simpleObject);
				var newObject = {};
				mappingArray.push(newObject);
				for (var p in simpleObject) 
					newObject[p] = f(simpleObject[p]);
				if(simpleObject.constructor) newObject.constructor = simpleObject.constructor;				
				return newObject;
			} else {
				return simpleObject;
			}
		} else {
			return mappingArray[indexOf];
		}
	};
	return f(obj);		
}

function ElementIsEnabled(element) {
	if (!element) return false;
	var classNames = element.className.split(' ');
	for (var i = 0; i < classNames.length; ++i) {
		var className = classNames[i];
		if (className == "enabled")
			return true;
		if (className == "disabled")
			return false;
	}
	return true;
}

function SetElementEnabled(elementID, enabled, title) {
	var element = document.getElementById(elementID);
	if (element) {
		var classNames = element.className.split(' ');
		var filteredClassNames = new Array();
		for (var i = 0; i < classNames.length; ++i) {
			var className = classNames[i];
			if (className == "enabled" || className == "disabled" || 0 == className.length)
				continue;
			filteredClassNames.push(className);
		}
		
		filteredClassNames.push(enabled ? "enabled" : "disabled");
		element.className = filteredClassNames.join(' ');
		element.title = title;
	}
}

function EnableAddToSourceList() {
	SetElementEnabled("AddToSourceList", true, null);
}

function DisableAddToSourceList() {
	SetElementEnabled("AddToSourceList", false, "This report is already in the source list");
}

function ClickSourceList(element) {
	var result = ElementIsEnabled(element);
	DisableAddToSourceList();
	return result;
}

function readCookie(name) {
	// stolen from http://www.quirksmode.org/js/cookies.html
	var nameEQ = name + "=";
	var ca = document.cookie.split(';');
	for(var i=0;i < ca.length;i++) {
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
	}
	return null;
}

function SortTables(cssSelector, sortColumnIndex, sortDirection) {
	var tables = $$(cssSelector);
	for (var i = 0; i < tables.length; ++i) {
		var table = tables[i];
//		var indexAndOrder = readCookie("table-sort " + table.id);
		var index = 0; var order = 1;
/*		if (null !== indexAndOrder) {
			indexAndOrder = indexAndOrder.split(' ');
			index = parseInt(indexAndOrder[0]) + 1;
			order = parseInt(indexAndOrder[1]);
		} */
		TableKit.Sortable.sort(table.id, index, order);
	}
}

function CurrencyMenuInit()
{
	var currencySelector = $("#currencyTypeSelect");
	if (currencySelector.length)
	{
		currencySelector.change( function() {
			var popup = $(this);
			var currencyID = popup.val();
			if( window.viewController )
				window.viewController.SelectCurrencyID(currencyID);
		});
	}
}

function SettingsButtonInit()
{
    var settingsButton = $(".settingsButton");
    if (settingsButton.length)
    {
        settingsButton.click(function() {
                             if (window.viewController)
                             window.viewController.InvokeSettings();
                             return false;
                             });
    }
    
    var settingsLink = $(".settingsLink");
	if (settingsLink.length)
	{
		settingsLink.click(function() {
			if (window.viewController)
				window.viewController.InvokeSettings();
			return false;
		});
	}

	var exportButton = $("#TXF");
	if (exportButton.length)
	{
		exportButton.click(function() {

			if (window.viewController)
				window.viewController.InvokeTaxExport();
			return false;
		});
	}

	var exportButton = $("#CSV");
	if (exportButton.length)
	{
		exportButton.click(function() {

						   if (window.viewController)
						   window.viewController.InvokeExport();
						   return false;
						   });
	}
}

$(SettingsButtonInit);

// intercept the ESC key to prevent crashing
var ESC = 27;
(function($) {
	$(document).bind("keyup",function(e) {
		if(e.keyCode == ESC) {
			e.preventDefault();
			e.stopPropagation();
		}			
		return false;
	});
})(jQuery);
