/* --------------------------- INTUIT CONFIDENTIAL ---------------------------

 slider.js

 Written by		Date
 Jun Yang		12/16/13


 Copyright 2010 Intuit, Inc All rights reserved. Unauthorized
 reproduction is a violation of applicable law. This material contains
 certain confidential and proprietary information and trade secrets of
 Intuit, Inc.

 RESTRICTED RIGHTS LEGEND

 Use, duplication, or disclosure by the Government is subject to
 restrictions as set forth in subdivision (b) (3) (ii) of the Rights in
 Technical Data and Computer Software clause at 52.227-7013.

 Intuit, Inc
 P.O. Box 7850
 Mountain View, CA 94039-7850

 ----------------------------- INTUIT CONFIDENTIAL ------------------------- */


var slider;
function sliderInit(container) {
    slider = $('.' + container);
    slider.maxPage = slider.children().length - 1;
    slider.currentPage = 0;
    slider.leftPosition = 0;
    slider.oneSlideLength = 700;
    $('.pagination_item a').first().addClass('active');

    //Add listener
    $('.btn_next').click(function (e) {
        e.preventDefault();
        nextPage();
        hideTimeSelectDiv();
    });
    $('.btn_prev').click(function (e) {
        e.preventDefault();
        prevPage();
        hideTimeSelectDiv();
    });
    $('.pagination_item a').click(function (e) {
        e.preventDefault();
        $('.pagination_item a').removeClass('active');
        $(this).addClass('active');
        gotoPage(this.innerHTML);
        hideTimeSelectDiv();
    });
}
function gotoPage(currentPage) {
    slider.currentPage = parseInt(currentPage);
    slider.leftPosition = -slider.currentPage * slider.oneSlideLength;
    slider.children().animate({left: slider.leftPosition + 'px'});
}
function nextPage() {
    if (slider.currentPage == slider.maxPage) {
        slider.currentPage = 0;
        slider.leftPosition = 0;
    } else {
        slider.currentPage += 1;
        slider.leftPosition = -slider.currentPage * slider.oneSlideLength;
    }
    $('.pagination_item a').removeClass('active');
    $('.pagination_item a[title="' + slider.currentPage + '"]').addClass('active');
    slider.children().animate({left: slider.leftPosition + 'px'});
}
function prevPage() {
    if (slider.currentPage == 0) {
        slider.currentPage = slider.maxPage;
        slider.leftPosition -= slider.maxPage * slider.oneSlideLength;
    } else {
        slider.currentPage -= 1;
        slider.leftPosition = -slider.currentPage * slider.oneSlideLength;
    }
    $('.pagination_item a').removeClass('active');
    $('.pagination_item a[title="' + slider.currentPage + '"]').addClass('active');
    slider.children().animate({left: slider.leftPosition + 'px'});
}
function hideTimeSelectDiv(){
    if(slider.currentPage == 0){
        setTimeout(function() {$('.time_frame_select_div').removeClass('hide');},400);
        $('.totalAmount').removeClass('hide');
        $('.spending_over_time_title').addClass('hide');
        $('.spending_over_time_title').html(' ');
    }else if(slider.currentPage == 1){
        $('.time_frame_select_div').addClass('hide');
        $('.totalAmount').addClass('hide');
        $('.spending_over_time_title').removeClass('hide');
        $('.net_income_title').html(' ');
        $('.spending_over_time_title').html('Spending Over Time');
    }else if(slider.currentPage == 2){
        $('.time_frame_select_div').addClass('hide');
        $('.totalAmount').addClass('hide');
        $('.net_income_title').html('Net Income');
        $('.spending_over_time_title').html(' ');
    }
}