/* --------------------------- INTUIT CONFIDENTIAL ---------------------------

	filterSettings.js

	Written by		Date 
	Jason Harris	02/04/10
	
	Revised by		Date		Summary of changes
	Mickey Roberson	08/09/10	[DE1040] Added display for "Any of"/"All of" for tags
	
	Copyright 2010 Intuit, Inc All rights reserved. Unauthorized
	reproduction is a violation of applicable law. This material contains
	certain confidential and proprietary information and trade secrets of
	Intuit, Inc.
		
	RESTRICTED RIGHTS LEGEND
		
	Use, duplication, or disclosure by the Government is subject to
	restrictions as set forth in subdivision (b) (3) (ii) of the Rights in
	Technical Data and Computer Software clause at 52.227-7013.
		
	Intuit, Inc
	P.O. Box 7850
	Mountain View, CA 94039-7850

----------------------------- INTUIT CONFIDENTIAL ------------------------- */

var gFilterSettingsDidInit = false;
var gFilterSettingsRequired = false;

function FilterSettingsInit(isRequired)
{
	if (!gFilterSettingsDidInit)
	{
		gFilterSettingsDidInit = true;
		
		var filterDefaultSettings = $(".filterDefaultSettings");
		gFilterSettingsRequired = isRequired || (0 == filterDefaultSettings.length);
		filterDefaultSettings.hide();
		
		if (gFilterSettingsRequired)
			$(window).resize(FilterSettingsInit);
		else
			$(".filterSettings").hide();
	}
	
	if (!gFilterSettingsRequired) return;
	
	var rows = $(".filterSettings tr");
	if (!rows.length) return;
	
	var maxHeight = $($(rows[0]).find("td")[0]).height();
	for (var i = 1; i < rows.length; ++i)
	{
		var row = $(rows[i]);
		var cells = row.find("td");
		var lists = row.find("ul");
		if (!lists.length) continue;
		
		var realList = $(lists[lists.length - 1]);
		realList.hide();
		
		var parent = realList.parent();
		var andMore = parent.children(".andMore");
		andMore.hide();
		var singleItem = parent.children(".singleItem");
		singleItem.hide();
		var multipleItems = parent.children(".multipleItems");
		multipleItems.hide();
		var zeroItems = parent.children(".zeroItems");
		zeroItems.hide();
		var tagSelectionType = parent.children(".tagSelectionType");
		tagSelectionType.hide();
			
		var displayList = null;
		if (lists.length == 1)
		{
			parent.prepend("<ul></ul>");
			displayList = parent.children("ul:first");
		}
		else
		{
			displayList = $(lists[0]);
			displayList.empty();
		}
		
		var realItems = realList.children("li");
		realItems.each(function()
		{
			displayList.append(this.outerHTML);
		});
		
		var realCount = realItems.length;
		var count = realCount;
		if (0 == count)
		{
			displayList.append('<li class="noSetting">' + zeroItems.text() + '</li>');
		}
		else
		{
			
			if(count > 1 && tagSelectionType.text())
				displayList.prepend(tagSelectionType.text() + " of ");

			while (count > 0)
			{
				var height = $(cells[1]).height();
				if (height <= maxHeight)
					break;
				
				var displayItems = displayList.children("li");
				var lastItem = $(displayItems[displayItems.length - 1]);
				if (lastItem.hasClass("andMore"))
				{
					lastItem.remove();
					lastItem = $(displayItems[displayItems.length - 2]);
				}
				
				--count;
				
				var text;
				if (count > 0)
				{
					text = andMore.text();
					text = text.replace("XXX", realCount - count);
				}
				else
				{
					if (1 == realCount)
						text = singleItem.text();
					else
					{
						text = multipleItems.text();
						text = text.replace("XXX", realCount);
					}
				}
					
				lastItem.replaceWith('<li class="andMore">' + text + '</li>');
			}
		}
	}
}
