/* --------------------------- INTUIT CONFIDENTIAL ---------------------------

	categorySummary.js

	Written by		Date 
	Jason Harris	08/12/09
	
	Revised by		Date		Summary of changes
	Lane Roathe		09-08-10	[S715] TopOnly now expands topLevel sections to show collapsed subs
	Lane Roathe		09/17/10	[DE1703] get show me state from report filters on init so returning to view doesn't reset to loaded state
	Lane Roathe		01/24/11	[S876] handling hiding/showing of memo/notes column w/adjustment of account/payee column widths
	Lane Roathe		01/28/11	[DE2089] updating collapsed states from header so entire section isn't a clickable area
										 Added checks for available function callbacks to prevent exceptions closing open files

	Copyright 2009-2011 Intuit, Inc All rights reserved. Unauthorized
	reproduction is a violation of applicable law. This material contains
	certain confidential and proprietary information and trade secrets of
	Intuit, Inc.
		
	RESTRICTED RIGHTS LEGEND
		
	Use, duplication, or disclosure by the Government is subject to
	restrictions as set forth in subdivision (b) (3) (ii) of the Rights in
	Technical Data and Computer Software clause at 52.227-7013.
		
	Intuit, Inc
	P.O. Box 7850
	Mountain View, CA 94039-7850

----------------------------- INTUIT CONFIDENTIAL ------------------------- */

// [DE1827] - Lane Roathe - can't use rows.animate because the animation
//							which hides/shows the rows happens after printing
function _ShowHideElements(elements, show, saveStates) {
	elements.each(function () {
		this.style.display = show ? '' : 'none';
	});
}

function _ShowElements(elements, saveStates) {
	_ShowHideElements(elements, true, saveStates);
}

function _HideElements(elements, saveStates) {
	_ShowHideElements(elements, false, saveStates);
}

function _TransactionEntryElements(tags) {
	var transactionEntryElements = tags.children(".collapsible").children(".transactionEntry");
	return transactionEntryElements;
}

function _OpenTag(tag, saveStates, transactionEntriesIncluded) {
	var childElements = tag.children('.collapsible');
	if (transactionEntriesIncluded)
		childElements = childElements.add(_TransactionEntryElements(tag));
	_ShowElements(childElements, saveStates);
	
	childElements.parent(".tagHeader").each(function() {
		var element = $(this);
		if (element.hasClass("closed"))
		{
			element.toggleClass("closed").toggleClass("opened");
			if( saveStates && window.viewController && window.viewController.SetTableState )
				window.viewController.SetTableState(element.attr('quickenid'), "opened");
		}
	});
	
	var tagHeader = tag.children('.tagHeader');
	tagHeader.css('-webkit-border-bottom-left-radius', '0px');
	tagHeader.css('-webkit-border-bottom-right-radius', '0px');
}

function _CloseTag(tag, saveStates) {
	var childElements = tag.children('.collapsible');
	childElements.add(_TransactionEntryElements(tag));
	_HideElements(childElements, saveStates);
	
	childElements.parent(".tagHeader").each(function() {
		var element = $(this);
		if (element.hasClass("opened"))
		{
			element.toggleClass("opened").toggleClass("closed");
			if( saveStates && window.viewController && window.viewController.SetTableState )
				window.viewController.SetTableState(element.attr('quickenid'), "closed");
		}
	});
	
	var tagHeader = tag.children('.tagHeader');
	tagHeader.css('-webkit-border-bottom-left-radius', '8px');
	tagHeader.css('-webkit-border-bottom-right-radius', '8px');
}

function _CloseTransactionEntries(tag, saveStates) {
	var childElements = _TransactionEntryElements(tag);
	_HideElements(childElements, saveStates);
	
	if (0 == tag.children('.treeCollection').length) {
		var tagHeader = tag.children('.tagHeader');
		tagHeader.css('-webkit-border-bottom-left-radius', '8px');
		tagHeader.css('-webkit-border-bottom-right-radius', '8px');
	}

	if (0 == tag.find(".collapsible .collapsible").length)
	{
		_CloseTag(tag, saveStates);
		return;
	}
}

function _OpenTags(tags, saveStates, childrenIncluded) {
	if (0 == tags.length) return;
	tags.each(function() {
		_OpenTag($(this), saveStates, true);
	});
	
	if (childrenIncluded)
		_OpenTags(tags.find('.tagHeader'), saveStates, childrenIncluded);
}

function _CloseTags(tags, saveStates, childrenIncluded) {
	if (0 == tags.length) return;
	tags.each(function() {
		_CloseTag($(this), saveStates);
	});
	
	if (childrenIncluded)
		_CloseTags(tags.find('.tagHeader'), saveStates, childrenIncluded);
}

function InitDisclosures() {
	var tagHeaders = $(".tagHeaderRow");
	tagHeaders.each(function() {
		var tagHeader = $(this).parent();

		if( window.viewController && window.viewController.TableState ) {
			var state = window.viewController.TableState(tagHeader.attr('quickenid'),"opened");
			if( state == "opened" )
				_OpenTags(tagHeader, false, true);
			else
				_CloseTags(tagHeader, false, true);
		}
		$(this).click(function(e) {
			var tagHeader = $(this).parent();
			var childrenIncluded = e.altKey;
			
			if (tagHeader.hasClass("closed"))
				_OpenTags(tagHeader, true, childrenIncluded);
			else if (tagHeader.hasClass("opened"))
				_CloseTags(tagHeader, true, childrenIncluded);

			if( window.viewController && window.viewController.SetAttribute )
				window.viewController.SetAttribute("showMeMode", "custom");

			updateFilterDescription("custom");

			return false;
		});
	});
}

function DisplaySummary(saveStates) {
	$('.tagHeader').each(function() {
		var thisTag = $(this);
		if (0 == thisTag.parent('.tagHeader').length) {
			_OpenTag(thisTag, saveStates, false);
			_CloseTransactionEntries(thisTag, saveStates);
		}
		else
			_CloseTag(thisTag, saveStates);
	});
}

function ShowAll(saveStates) {
	$('.tagHeader').each(function() {
		var thisTag = $(this);
		_OpenTag(thisTag, saveStates, true);
	});
}

function TopOnly(saveStates) {
	$('.tagHeader').each(function() {
		var thisTag = $(this);
		_CloseTag(thisTag, saveStates);
		if (thisTag.hasClass("topLevel"))
			_OpenTag(thisTag, saveStates, false);
	});
}

function updateFilterDescription(newValue) {
	var newState;
	if (newValue == "summary")
		newState = "Summary for all categories";
	else if (newValue == "showAll")
		newState = "Details for all categories";
	else if (newValue == "topOnly")
		newState = "Top-level categories only";
	else
		newState = "Custom";

	var showMeElement = $('#showMeMode').find('li')[0];
	showMeElement.textContent = newState;
}

function updateShowMeFilter(newValue) {
	updateFilterDescription(newValue);
}

function UpdateNotesVisibility(showNotes) {

	$('input[name=showNotes]').attr('checked', showNotes);

	var notes = $(".note");
	if( notes.length )
	{
		var accounts = $(".account");
		if( accounts.length )
			var accountWidth = accounts[0].offsetWidth;
		var payees = $(".payee");
		if( payees.length )
			var payeeWidth = payees[0].offsetWidth;
		var transAccounts = $(".transAccounts");
		if( transAccounts.length )
			var transAccountWidth = transAccounts[0].offsetWidth;
		var transPayees = $(".transPayee");
		if( transPayees.length )
			var transPayeeWidth = transPayees[0].offsetWidth;

		if( showNotes )
		{
			notes.show();

			accounts.css({
				width: 120
			});
			payees.css({
				width: 210
			});
			transAccounts.css({
				width: 160
			});
			transPayees.css({
				width: 170
			});
		}
		else
		{
			accounts.css({
				width: 120 + 60
			});
			payees.css({
				width: 210 + 100
			});
			transAccounts.css({
				width: 160 + 60
			});
			transPayees.css({
				width: 170 + 100
			});

			notes.hide();
		}
	}
}

function ShowNotesDidChange(selectElement) {
	var newValue = selectElement.checked;
	if( window.viewController && window.viewController.ShowNotesDidChange )
		window.viewController.ShowNotesDidChange(newValue);

	UpdateNotesVisibility(newValue);
}

function ViewAsDidChange(selectElement, saveStates) {
	var newValue = selectElement.value;

	if (newValue == "summary")
		DisplaySummary(saveStates);
	else if (newValue == "showAll")
		ShowAll(saveStates);
	else if (newValue == "topOnly")
		TopOnly(saveStates);
	else
		return;

	updateShowMeFilter(newValue);

	if( window.viewController && window.viewController.ShowMeModeDidChange )
		window.viewController.ShowMeModeDidChange(newValue);
}

function ShowMeSetup() {
	var showNotes = (window.viewController ? window.viewController.ShowNotesState() : "true");
	if( showNotes == "false" )
		UpdateNotesVisibility(false);

	var newValue = (window.viewController ? window.viewController.GetAttribute("showMeMode") : "showAll");
	updateShowMeFilter(newValue);
}
