/* --------------------------- INTUIT CONFIDENTIAL ---------------------------

	transactionDetail.js

	Written by		Date 
	Jason Harris	04/02/09
	
	Revised by		Date		Summary of changes

	
	Copyright 2009 Intuit, Inc All rights reserved. Unauthorized
	reproduction is a violation of applicable law. This material contains
	certain confidential and proprietary information and trade secrets of
	Intuit, Inc.
		
	RESTRICTED RIGHTS LEGEND
		
	Use, duplication, or disclosure by the Government is subject to
	restrictions as set forth in subdivision (b) (3) (ii) of the Rights in
	Technical Data and Computer Software clause at 52.227-7013.
		
	Intuit, Inc
	P.O. Box 7850
	Mountain View, CA 94039-7850

----------------------------- INTUIT CONFIDENTIAL ------------------------- */

var gOverflowUserTags = {};

function UserTagsInit()
{
	// - Use the header as the height of one row. It's not exact, but it's good 
	//   enough.
	
	var anyHeaderRow = $('.transactionDetail')[0].tHead.rows.item(0);
	anyHeaderRow = $(anyHeaderRow);
	var kMaxDimension = anyHeaderRow.height();
	
	var userTags = $('.userTags');
	for (var i = 0; i < userTags.length; ++i)
	{
		var userTag = $(userTags[i]);
		var items = userTag.children('li');
		var originalHTML = userTag.get(0).outerHTML;
		
		var didModify = false;
		while (userTag.height() > kMaxDimension)
		{
			didModify = true;
			
			var lastItem = $(items.get(items.length-1));
			if ('...' == lastItem.text())
			{
				items = items.slice(0, -1);
				lastItem.remove();
				lastItem = $(items.get(items.length-1));
			}
				
			lastItem.text('...');
			var dimensions = userTag.height();
		}
		
		if (didModify)
		{
			var trElement;
			var parent = userTag.parent();
			while (parent.length) {
				if ("TR" == parent.get(0).tagName)
				{
					trElement = parent;
					break;
				}
				parent = parent.parent();
			}
			
			var shortenedHTML = userTag.get(0).outerHTML;
			var entry = {
				'originalHTML': originalHTML, 
				'shortenedHTML': shortenedHTML
			};
			
			var quickenID = trElement.get(0).id.split('_')[1];
			gOverflowUserTags[quickenID] = entry;

			trElement.mouseover(function() {
				SetRowMousedOver(this, true);
			});
		}
	}
}


var gMouseMovedFunction = null;

function SetRowMousedOver(trElement, mousedOver)
{
	trElement = $(trElement);
	var quickenID = trElement.get(0).id.split('_')[1];
	var entry = gOverflowUserTags[quickenID];
	
	var userTags = trElement.find('.userTags')[0];
	userTags = $(userTags);
	
	if (mousedOver)
	{
		userTags.replaceWith(entry['originalHTML']);
		if (!trElement.hasClass('expanded'))
			trElement.addClass('expanded');

		gMouseMovedFunction = function(event) {
			SetRowMouseMoved(quickenID, event);
		};
		
		$(document).bind("mousemove", gMouseMovedFunction);
	}
	else
	{
		userTags.replaceWith(entry['shortenedHTML']);
		if (trElement.hasClass('expanded'))
			trElement.removeClass('expanded');

		$(document).unbind("mousemove", gMouseMovedFunction);
		gMouseMovedFunction = null;
	}
}


function SetRowMouseMoved(quickenID, event)
{
	var trElement = $('#transaction_' + quickenID);
	var foundElement = null;
	var parent = $(event.target);
	while (parent.length) {
		if ("TR" == parent.get(0).tagName)
		{
			foundElement = parent;
			break;
		}
		parent = parent.parent();
	}

	if (!foundElement || foundElement.attr('id') != trElement.attr('id'))
		SetRowMousedOver(trElement, false);
}
