/* --------------------------- INTUIT CONFIDENTIAL ---------------------------

	overview.js

	Written by		Date 
	Jason Harris	10/19/09
	
	Revised by		Date		Summary of changes
	Lane Roathe		06/22/10	[DE1411] check window.viewController usage to fix deferred printing
								(Some reports do not have a viewController or attached method)
	Lane Roathe		01/20/11	Update position calculations to use true offest (not absolute positions)

	Copyright 2009-2010 Intuit, Inc All rights reserved. Unauthorized
	reproduction is a violation of applicable law. This material contains
	certain confidential and proprietary information and trade secrets of
	Intuit, Inc.
		
	RESTRICTED RIGHTS LEGEND
		
	Use, duplication, or disclosure by the Government is subject to
	restrictions as set forth in subdivision (b) (3) (ii) of the Rights in
	Technical Data and Computer Software clause at 52.227-7013.
		
	Intuit, Inc
	P.O. Box 7850
	Mountain View, CA 94039-7850

----------------------------- INTUIT CONFIDENTIAL ------------------------- */

function OverviewInit()
{
	$(".accountList").accountsExpander();
	
	// position the horizontal today marker
	var todayRows = $("#upcomingBillsTable .today");
	var outers = $(".hTodayMarkerOuter");
	var inners = $(".hTodayMarkerInner");
	if (!todayRows.length)
	{
		outers.hide();
		inners.hide();
	}
	else
	{
		var todayRow = todayRows[0];		// get individual elements so we can get true offset data
		var inner = inners[0];
		var outer = outers[0];

		var top = todayRow.offsetTop - 30;

		todayRows.hide();

		var topoffset = top + outer.offsetTop;
		outers.css('top', topoffset + 'px');
		topoffset = top + inner.offsetTop - 8;
		inners.css('top', topoffset + 'px');

		inners.html(todayRows.html());
	}	
	
	$(".updateAllBtn").click(function() {
		if( window.viewController )
			window.viewController.UpdateAllAccounts();
		return false;
	});
		
	SpendingTrendsInit("", "");
	UpcomingTransactionsInit();
	QuickZoomTransactionsInit();
	BudgetGoalsInit();
	CurrencyMenuInit();
}


function ExploreCategory(quickenIDs)
{
	if (0 == quickenIDs.length)
		quickenIDs = "__other__";
	if( window.viewController )
		window.viewController.ExploreCategoryWithQuickenIDs(quickenIDs);
}


function DisplayAccount(quickenID)
{
	if( window.viewController )
		window.viewController.DisplayAccountWithQuickenID(quickenID);
	return false;
}

function ShowAssistant(identifier)
{
	if( window.viewController )
		window.viewController.ShowAssistant(identifier);
	return false;
}

function ShowCategoryExplorer()
{
	if( window.viewController )
		window.viewController.ShowCategoryExplorer();
	return false;
}
