/* --------------------------- INTUIT CONFIDENTIAL ---------------------------

	deferredPrinting.js

	Written by		Date 
	Jason Harris	04/30/10
	
	Revised by		Date		Summary of changes
	Lane Roathe		06/22/10	[DE1411] check window.viewController usage to fix deferred printing
								(Some reports do not have a viewController or attached method)

	Copyright 2010 Intuit, Inc All rights reserved. Unauthorized
	reproduction is a violation of applicable law. This material contains
	certain confidential and proprietary information and trade secrets of
	Intuit, Inc.
		
	RESTRICTED RIGHTS LEGEND
		
	Use, duplication, or disclosure by the Government is subject to
	restrictions as set forth in subdivision (b) (3) (ii) of the Rights in
	Technical Data and Computer Software clause at 52.227-7013.
		
	Intuit, Inc
	P.O. Box 7850
	Mountain View, CA 94039-7850

----------------------------- INTUIT CONFIDENTIAL ------------------------- */

function PrintingTokenCollection() {
	PrintingTokenCollection.prototype.size = function() {
		var size = 0, key;
		for (key in this)
			if (this.hasOwnProperty(key)) size++;
		return size;
	};
};

var gDeferredPrintingTokenIndex = 0;
var gOutstandingPrintingTokens = new PrintingTokenCollection();

function CreateDeferredPrintingToken() {
	var token = gDeferredPrintingTokenIndex++;
	gOutstandingPrintingTokens[token] = ' ';
	return token;
}

function CheckInDeferredPrintingToken(token) {
	delete gOutstandingPrintingTokens[token];
	if (0 == gOutstandingPrintingTokens.size())
		NotifyPrintReady();
}

function NotifyPrintReady() {
	if( window.printViewController )
		window.printViewController.NotifyPrintReady();
}