/* --------------------------- INTUIT CONFIDENTIAL ---------------------------

	budgetGoals.js

	Written by		Date 
	Jason Harris	11/12/09

	Revised by		Date		Summary of changes
	Lane Roathe		06/22/10	[DE1411] check window.viewController usage to fix deferred printing
								(Some reports do not have a viewController or attached method)
	Lane Roathe		07/12/10	[S593] Hook in UI buttons to javascript callbacks to view controller
	Lane Roathe		07/19/10	[DE1471] move settings button back to budget view only js file
	Dan Herman		07/19/10	[DE1472] fix horizontal positioning of "Today" date box relative to date line
	Mickey Roberson	09/01/10	[DE1404] Vertical line for "Today" marker now scales to the current budget height
	Dan Herman		09/10/10	[DE1656] re-fix horizontal positioning of "Today" date box and date line
								for the Overview report in the case there is a single budget
	Mickey Roberson	09/17/10		[DE1711] Fixed a JS crash where a budget had no tables
	Chris Campbell	10/13/10	[DE534] Setting up a window resize handler in BudgetGoalsInit() that will
									re-position the "Today" marker when the window is resized by calling
									PositionBudgetGoalsTodayMarker()
	Chris Campbell	10/19/20	[DE1867] Conditionalizing the code in BudgetGoalsInit() that sets up the
									quickzoom hover functionality for the budget goals table. This functionality
									should only be enabled for the mini-budget that appears in the Overview;
									it should not be enabled for a budget report. (I changed the budget report
									to call BudgetGoalsInit() in revision r5717 for DE534, which cause the quickzoom
									hover functionality to be enabled for budget reports.)
	Mickey Roberson	11/02/10	[DE1832] Budgets may now be composed of multiple tables (1 .first, multiple .middle and 1 .last)
									Vertical today marker height is now a calculated value to account for this.
	Lane Roathe		01/10/11	[S868] modify calculation of vLeft to allow for relative date indicator positioning (vs absolute)
	Lane Roathe		01/119/11	[DE2063] Noticed today indicator position was off, correct (was using an "arrays" position instead of the elements offset)
	Lane Roathe		02/26/11	[DE2126] Correct calculation of today marker and container size (prevents exess blank space below table)

	Copyright 2009-2011 Intuit, Inc All rights reserved. Unauthorized
	reproduction is a violation of applicable law. This material contains
	certain confidential and proprietary information and trade secrets of
	Intuit, Inc.

	RESTRICTED RIGHTS LEGEND

	Use, duplication, or disclosure by the Government is subject to
	restrictions as set forth in subdivision (b) (3) (ii) of the Rights in
	Technical Data and Computer Software clause at 52.227-7013.

	Intuit, Inc
	P.O. Box 7850
	Mountain View, CA 94039-7850

----------------------------- INTUIT CONFIDENTIAL ------------------------- */

function BudgetGoalsInit()
{
	var budgetSelector = $("#upcomingMonthSelect");
	if (budgetSelector.length)
	{
		budgetSelector.change( function() {
			var popup = $(this);
			var quickenID = popup.val();
			SelectBudget(quickenID);
			if( window.viewController && window.viewController.SelectBudgetWithQuickenID )
				window.viewController.SelectBudgetWithQuickenID(quickenID);
		});

		SelectBudget(budgetSelector.val());
	}
	else
	{
		// [DE1656] no selector (because there aren't multiple budgets)? Not calling SelectBudget(),
		// so need to invoke PositionBudgetGoalsTodayMarker() directly.
		PositionBudgetGoalsTodayMarker();
		$(".savingsGoalsTableWrapper").addClass('currentBudget');
	}

	if( window.viewController && window.viewController.DisplayBudgetWithQuickenID )
	{
		var budgetTables = $(".savingsGoalsTableWrapper");

		budgetTables.hover(function() {
			var element = $(this);
			element.addClass("quickzoom");
		}, function() {
			var element = $(this);
			element.removeClass("quickzoom");
		});

		budgetTables.click(function() {
			var quickenID = this.id;

				window.viewController.DisplayBudgetWithQuickenID(quickenID);
			return false;
		});
	}

	$(window).resize(function() {
					 PositionBudgetGoalsTodayMarker();
					 });
}

function PositionBudgetGoalsTodayMarker()
{
	// position the vertical today marker
	var tables = $(".savingsGoalsTableWrapper");
	if(tables.length == 0)
		return;

	tables.each(function() {
		if($(this).is(":visible")) {
			var wrapper = $(this);

			var firstTable = wrapper.find(".savingsGoalsTable.first");
			var headers = firstTable.find("thead");
			var header = headers[0];
			var goalColumns = headers.find(".goalPercentHdr");
			// In order to get the relative offset, we need to use the actual HTML element, not a generic object
			var goalColumn = goalColumns[0];

			var todayMarker = wrapper.find(".todayMarker");
			var todayFractionElement = todayMarker.find(".todayFraction");
			var outerMarker = todayMarker.find(".vTodayMarkerOuter");
			var innerMarker = todayMarker.find(".vTodayMarkerInner");

			todayFractionElement.hide();
			if (!todayFractionElement.length)
			{
				outerMarker.hide();
				innerMarker.hide();
			}
			else
			{
				var todayFraction = parseFloat(todayFractionElement.text());
				var vLeft = goalColumn.offsetLeft + (goalColumn.offsetWidth * todayFraction);
				var vHeight = wrapper.height() - (header.offsetHeight * 2) + 12;

				outerMarker.css({
					height: vHeight,
					left: vLeft
				});
				innerMarker.css({
					left: vLeft + 2 - (innerMarker.width() / 2.0)
				});
				todayMarker.css({
					top: -vHeight - 20,
					height: innerMarker.height()
				});
			}
		}
	});
}

function SelectBudget(quickenID)
{
	var tables = $(".savingsGoalsTableWrapper");
	for (i = 0; i < tables.length; ++i)
	{
		var table = $(tables[i]);
		if (table[0].id == quickenID){
			table.show();
			table.addClass('currentBudget');
		}else {
			table.hide();
			table.removeClass('currentBudget');
		}
	}

	PositionBudgetGoalsTodayMarker();
}

$(BudgetsButtonInit);

function BudgetsButtonInit()
{
	var budgetPreviousDate = $("a.prevItemButton");
	if( budgetPreviousDate.length )
	{
		budgetPreviousDate.click(function() {
			if( window.viewController )
				window.viewController.PreviousDateForBudget();
			return false;
		});
	}

	var budgetCurrentDate = $("a.currentItemButton");
	if( budgetCurrentDate.length )
	{
		budgetCurrentDate.click(function() {
			if( window.viewController )
				window.viewController.CurrentDateForBudget();
			return false;
		});
	}

	var budgetNextDate = $("a.nextItemButton");
	if( budgetNextDate.length )
	{
		budgetNextDate.click(function() {
			if( window.viewController )
				window.viewController.NextDateForBudget();
			return false;
		});
	}
}
