/* --------------------------- INTUIT CONFIDENTIAL ---------------------------

	budgets.js

	Written by		Date
	Jason Harris	11/17/09

	Revised by		Date		Summary of changes
	Lane Roathe		05/27/10	[1099] add budget detail links
	Lane Roathe		06/22/10	[DE1411] check window.viewController usage to fix deferred printing
								(Some reports do not have a viewController or attached method)
	Lane Roathe		07/12/10	[S593] moved button code to budgetGoals.js since it's the only one shared by budget views
	Lane Roathe		07/19/10	[DE1471] moved one to many functions, settings button only in budget view!
	Chris Campbell	10/13/10	[DE534] Changing BudgetsInit() to call BudgetGoalsInit() instead of calling
									PositionBudgetGoalsTodayMarker() directly (BudgetGoalsInit() does other stuff too)

	Copyright 2009-2010 Intuit, Inc All rights reserved. Unauthorized
	reproduction is a violation of applicable law. This material contains
	certain confidential and proprietary information and trade secrets of
	Intuit, Inc.

	RESTRICTED RIGHTS LEGEND

	Use, duplication, or disclosure by the Government is subject to
	restrictions as set forth in subdivision (b) (3) (ii) of the Rights in
	Technical Data and Computer Software clause at 52.227-7013.

	Intuit, Inc
	P.O. Box 7850
	Mountain View, CA 94039-7850

----------------------------- INTUIT CONFIDENTIAL ------------------------- */

function BudgetsInit()
{
	BudgetGoalsInit();
	PositionModalBudgetGoalMarkers();

	var oldDetail;
	var oldTarget;
	var timer;
    var activeModalId = '';
	$("a",".budgetYear").hover(function(e) {
		clearTimeout(timer);
		if(oldDetail)
			oldDetail.hide()
		oldTarget = this;
		var fullHeight = $(this).parents("li").height();
		var barHeight = $("span.bar",this).height();
		var itemDetail = $(this).siblings(".budgetItemAmount");
		var totalHeight = fullHeight - barHeight - itemDetail.outerHeight() - 5;
		oldDetail = itemDetail;
		var parent = itemDetail.parents(".budgetDetailModal");
		var top = totalHeight + "px";
		// console.log(itemDetail.outerHeight());
		itemDetail.css({
			top: 0,
			left: 0 - (itemDetail.width()/2)
		});
		itemDetail.show();
	},function(e) {
		timer = setTimeout(function() {oldDetail.hide();},300);
	});

	$(".buttonLink").bind("click",function() {
		if( window.viewController )
			window.viewController.InvokeSettings();
		return false;
	});
	$("a.openBudgetDetail").bind("click",function() {
		var id = this.rel;
		HideModal(".budgetDetailModal");
        if(activeModalId != id){
            OpenModal(this,id);
            activeModalId = id;
        }else{
            activeModalId = '';
		}
		return false;
	});
	$("a.openBudgetDetailLink").bind("click",function() {
		var id = this.rel;
		HideModal(".budgetDetailModal");
        if(activeModalId != id){
            OpenModal(this,id);
            activeModalId = id;
        }else{
            activeModalId = '';
		}
		return false;
	});
	$("a.closeModal").bind("click",function() {
		var id = this.rel;
		HideModal("#"+id);
		return false;
	});
	$("a.budgetItemLink").bind("click",function() {
		if( window.viewController )
		{
			var that = $(this);
			var quickenIDs = that.attr('quickenids');
			var date = that.attr('date');
			window.viewController.DisplayTagCloudDetail(quickenIDs, date);
		}
		return false;
	});
    $("div.goalMarker").bind("click",function() {
    if (window.viewController)
        window.viewController.InvokeSettings();
	});
}

function OpenModal (linkage,id) {
	var modal = $("#"+id);
    var modalParent = modal.parent().parent();
    modalParent.addClass('activeModal');
    if($('.savingsGoalsTable tr:last')[0] == modalParent[0]){
        var newHeight = parseInt($('.todayMarker').css('top')) + 30;
        $('.todayMarker').css('top',newHeight+"px");//[DE3620]position today Marker for the last budget histroy element
    }
	var top = $(linkage).offset().top - modal.parents("td").height() - 20;
	modal.css({"top":0});
	modal.fadeIn();
    
    //dynamically adjust the goalMarker width
    var amountLength = modal.find('span.goalAmount').text().length;
    if(amountLength > 8){
        var newWidth = 52 + (amountLength - 6) * 6;//adding 6px per digit
        modal.find('div.goalMarker').css("background-size", newWidth + "px 39px");
    }
    
	$(document).bind("keyup",function(e) {
		if(e.keyCode == ESC) HideModal(modal);
	});
    $('.todayMarker').hide();
}

function HideModal (el) {
	$(el).hide();
    $('.activeModal').removeClass('activeModal');
    $('.todayMarker').show();
    PositionBudgetGoalsTodayMarker();
}

function PositionModalBudgetGoalMarkers()
{
	var points = $(".goalMarkerPoint");
	for (var i = 0; i < points.length; ++i)
	{
		var point = $(points[i]);
		var container = point.parent();
		var line = container.find('.goalLine');
		var goalFraction = parseFloat(container.children(".goalPercent").text()) / 100.0;
		var anyBar = container.find('li::first');
		var startY = 86; //anyBar.offset().top - container.offset().top;
		var y = startY + 105/*anyBar.height()*/ * (1.0 - goalFraction);
		line.css({top: y+'px'});
		point.css({top: y - 40/*point.height()*/ / 2.0 + 'px'});
	}
}
