/* --------------------------- INTUIT CONFIDENTIAL ---------------------------

	taxScheduleCAD.js

	Written by		Date 
	Dan Herman		08/26/10
	
	Revised by		Date		Summary of changes
	Lane Roathe		09/17/10	[DE1703] get summarize state from report filters on init so returning to view doesn't reset to loaded state

	Copyright 2010 Intuit, Inc All rights reserved. Unauthorized
	reproduction is a violation of applicable law. This material contains
	certain confidential and proprietary information and trade secrets of
	Intuit, Inc.
		
	RESTRICTED RIGHTS LEGEND
		
	Use, duplication, or disclosure by the Government is subject to
	restrictions as set forth in subdivision (b) (3) (ii) of the Rights in
	Technical Data and Computer Software clause at 52.227-7013.
		
	Intuit, Inc
	P.O. Box 7850
	Mountain View, CA 94039-7850

----------------------------- INTUIT CONFIDENTIAL ------------------------- */

function SummarizeByDidChange(selectElement) {
	var newValue = selectElement.value;
	var data = {};
	if (window.viewController)
	{
		window.viewController.SummarizeByModeDidChange(newValue);
	}
}

function SummarizeByFromString(newValue) {
	var data = {};
	if (window.viewController)
	{
		// GetRealizedGainLoss( bool mergeAccounts, bool mergePositions );
		data =  eval("(" + window.viewController.GetRealizedGainLoss(true, false) + ")");
 		this.createScheduleD(data);
	}
}

function createScheduleD(rawData){
	var rows = rawData['realizedGainLoss'];

    $('.scheduleDTable').each(function() {
                  
        // The closest currency label above dictates the currency of the table
        var previousCurrency = $(this).parent().prevAll('.currencyID:first');
        var tableCurrency;
                              
        // No currency labels means all data is the same currency
        if (previousCurrency.length == 0) {
            if (rows.length > 0) {
                tableCurrency = rows[0]['accountCurrencyCode'];
            }
        } else {
            tableCurrency = previousCurrency[0].getAttribute('data-currency-code');
            if (tableCurrency == null) {
                tableCurrency = rows[0]['accountCurrencyCode'];
            }
        }
                              
	    var account = '';
	    var termAccountName ='';
	    var termTable = '<tr class="tableTitle collapsibleHeader topHeader longTermTable"><td class="longTermTableTitle" colspan="4">Capital Gains</td><td class="longTermTableProcessds processds"></td><td class="longTermTableCost costBasis"></td><td class="longTermTableGainLoss gainLoss last"></td></tr>';

        var containsSomeData = false;
	    for(var i = 0; i < rows.length; i++){
		    var data = rawData['realizedGainLoss'][i];
		    var columns = data['holdingLots'];
                              
            // Check if correct currency for table
            if (data['accountCurrencyCode'] != tableCurrency) {
                continue;
            } else {
                containsSomeData = true;
            }
                              
	    	for (var j = 0; j < columns.length; j++){//create data per account
                if(data['accountName'] != termAccountName){//accountName doesn't exist in the table
                    termAccountName = data['accountName'];
                    termTable += '<tr class="collapsibleHeader longTermTitle longTermTable"><td class="accountTitle" colspan="7" id="longTermAccount_'+data['accountName']+'">' +  data['accountName'] + " (" + data['securityType'] + ')</td></tr>';
                }
                termTable += '<tr class="longTermItem">';
                termTable += '<td class="security" id="security_'+data['tickerSymbol']+'">' + (data['tickerSymbol'] ? data['tickerSymbol'] : data['securityName']) + '</td>';
                termTable += '<td class="shares" id="shares_'+data['tickerSymbol']+'">' +  columns[j]['units'] + '</td>';
                termTable += '<td class="dateAcquired" id="dateAcquired_'+data['tickerSymbol']+'">' + dateFormatter(columns[j]['purchaseDate'].slice(0,10)) + '</td>';
                termTable += '<td class="dateSold" id="dateSold_'+data['tickerSymbol']+'">' +  dateFormatter(columns[j]['sellDate'].slice(0,10)) + '</td>';
                termTable += '<td class="processds' + (columns[j]['netProceeds'] < 0 ? " netNegative" : "")+'" id="proceeds_'+data['tickerSymbol']+'">' +  formatMoney(columns[j]['netProceeds']) + '</td>';
                termTable += '<td class="costBasis' + (columns[j]['costBasis'] < 0 ? " netNegative" : "")+'" id="costBasis_'+data['tickerSymbol']+'">' +  formatMoney(columns[j]['costBasis']) + '</td>';
                termTable += '<td class="gainLoss last' + (columns[j]['priceGainLoss'] < 0 ? " netNegative" : "")+'" id="gainLoss_'+data['tickerSymbol']+'">' +  formatMoney(columns[j]['priceGainLoss']) + '</td>';
                termTable += '</tr>';
		    }//end of the j loop
	    }//end of the i loop
        if(termTable.indexOf('longTermItem') > -1){
            account += termTable + '<tr><td class="tableWhiteSpace" colspan="8"> space</td></tr>';
        }

    
        var x = window.document.getElementById("innerWrapperZeroDataCategory");
        if(x)
            x.parentNode.removeChild(x);
    
	    $(this).append(account);
    
	    //schedule 3 total
        $('.longTermTableCost',this).text(calculateTotal($('tr.longTermItem td.costBasis',this)));
        $('.longTermTableGainLoss',this).text(calculateTotal($('tr.longTermItem td.gainLoss',this)));
        $('.longTermTableProcessds',this).text(calculateTotal($('tr.longTermItem td.processds',this)));

        if (containsSomeData) {
            $(this).parent().removeClass('hide');
            previousCurrency.removeClass('hide');
        }
    });

    
    
	//schedule 3 arrow direction
	$(".scheduleDHeader").click(function() {
		$(this).toggleClass("opened").toggleClass("closed");
	});
	//event listener
	var oneHeader = $(".collapsibleHeader");
	oneHeader.each(function() {
		$(this).click(function(e) {
			if($(this).hasClass('topHeader')){//hide the account title
				if($(this).hasClass('termTable')){
					if($('.longTermTitle',this).hasClass('hide')){
						$('.longTermTitle',this).removeClass('hide');
						$('.longTermItem',this).removeClass('hide');
					}else{
						$('.longTermTitle',this).addClass('hide');
						$('.longTermItem',this).addClass('hide');
					}
				}
			}else{
				$(this).nextUntil('tr.collapsibleHeader').toggleClass('hide');
			}
		});
	});
}

function calculateTotal(fields){
	var sum = 0;
	fields.each(function() {
		sum += Number(this.innerHTML.replace("$","").replace(/,/g,''));
	});
	return formatMoney(sum);
}

function dateFormatter(date){
	var dateParts = date.split(/-/);
	var d = new Date(dateParts[0],parseInt( dateParts[1], 10) -1,dateParts[2]);
	return dateParts[1] + "/" + dateParts[2] + "/" + dateParts[0];
}
function formatMoney(number){
	var dot = ".",
		comma = ",",
		sign = number < 0 ? "-$" : "$",
		absValue = parseInt(number = Math.abs(+number || 0)).toString(),
		numOfComma = (numOfComma = absValue.length) > 3 ? numOfComma % 3 : 0;
	return sign + (numOfComma ? absValue.substr(0, numOfComma) + comma : "") + absValue.substr(numOfComma).replace(/(\d{3})(?=\d)/g, "$1" + comma)+ dot + Math.abs(number - absValue).toFixed(2).slice(2);
}
