/* --------------------------- INTUIT CONFIDENTIAL ---------------------------

	tagCloud.js

	Written by		Date 
	Jason Harris	12/18/09
	
	Revised by		Date		Summary of changes
	Lane Roathe		04/28/10	Track sort value between views (transient value)
	Lane Roathe		06/22/10	[DE1411] check window.viewController usage to fix deferred printing
								(Some reports do not have a viewController or attached method)

	Copyright 2010 Intuit, Inc All rights reserved. Unauthorized
	reproduction is a violation of applicable law. This material contains
	certain confidential and proprietary information and trade secrets of
	Intuit, Inc.
		
	RESTRICTED RIGHTS LEGEND
		
	Use, duplication, or disclosure by the Government is subject to
	restrictions as set forth in subdivision (b) (3) (ii) of the Rights in
	Technical Data and Computer Software clause at 52.227-7013.
		
	Intuit, Inc
	P.O. Box 7850
	Mountain View, CA 94039-7850

----------------------------- INTUIT CONFIDENTIAL ------------------------- */

function TagCloudInit()
{
	FilterSettingsInit(false);
	var selected = 0;
	if( window.viewController )
		selected = window.viewController.SortColumn();
	SortBy( selected );
	selObj = document.getElementById("timeFrameSelect");
	selObj.selectedIndex = selected;

	$("#timeFrameSelect").change(function() {
		var selected = document.getElementById("timeFrameSelect").selectedIndex;
		if( window.viewController )
			window.viewController.SetSortColumn( selected );
		SortBy( selected );
	});
}

function CreateLineBreaks() {
	var cont = $(".tagCloudCont");
	var tags = $(".tagCloudCont a");
	tags.each(function() {
		var tag = $(this);
		var tagHeight = tag.height();
		var className = tag.attr('class');
		cont.prepend("<a class='" + className + "'>M</a>");
		var mTag = cont.find("a:first");
		var baseHeight = mTag.height();
		mTag.remove();
		var lineCount = Math.floor(tagHeight / baseHeight + 0.5);
		if (lineCount > 1)
			tag.after("<br/>");
	});
}

function RemoveLineBreaks() {
	var breaks = $(".tagCloudCont>br");
	breaks.remove();
}

function CreateHovers() {
	var cont = $(".tagCloudCont");
	var tags = $(".tagCloudCont a");
	var meta = $(".tagCloudCont .tagMeta");
	var oldMeta = "";
	var metaTimer;
	var pageWidth = $("#innerWrapper").innerWidth();
	tags.hover(function() {
		var that = this;
		metaTimer = window.setTimeout(function() {
			tags.each(function(i) {
				if(this == that) {
					var offsetL = that.offsetLeft;
					var tagCloudContWidth = $(".tagCloudCont").width();
					oldMeta = $(meta[i]);
					if(offsetL < 30) {
						var left = offsetL;
						oldMeta.addClass("left");
					}
					else if(offsetL + oldMeta.width() > tagCloudContWidth) {
						var left = that.offsetLeft - (oldMeta.width() - that.offsetWidth);
						oldMeta.addClass("right");
					}
					else {
						var left = Math.round(offsetL - (oldMeta.width()/2) + (that.offsetWidth/2));
					}
					oldMeta.css({
						top: that.offsetTop - oldMeta.outerHeight() - 17,
						left: left
					});
					oldMeta.fadeIn();
				}
			});
		},250);
	},function() {
		if(metaTimer) {
			clearTimeout(metaTimer);
			oldMeta.hide();
		}
	});
	tags.click(function() {
		var that = $(this);
		var quickenIDs = that.attr('quickenids');
		var title = that.text();
		if( window.viewController )
			window.viewController.DisplayTagCloudDetail(quickenIDs, title);
		return false;
	});
}

function DoSort(sortFn) {
	// RemoveLineBreaks();
	var cont = $(".tagCloudCont");
	var tags = $(".tagCloudCont a");
	var metas = $(".tagCloudCont .tagMeta");
	var data = [];
	var i, length = tags.length;
	for (i = 0; i < length; ++i) {
		var tag = $(tags[i]);
		var meta = $(metas[i]);
		data.push({tag: tag, meta: meta});
	}
	tags.remove();
	metas.remove();
	data = $(data.sort(sortFn));
	data.each(function() {
		cont.append(this.tag);
		cont.append(document.createTextNode(" "));
	});
	data.each(function() {
		cont.append(this.meta);
	});
	CreateLineBreaks();
	CreateHovers();
}

function SortFrequency() {
	DoSort(function(a_, b_) {
		var a = parseFloat(a_.meta.find(".rawUseCount").html());
		var b = parseFloat(b_.meta.find(".rawUseCount").html());
		if (a == b) return 0;
		return (a > b) ? -1: 1;
	});
}

function SortAlphabetically() {
	DoSort(function(a_, b_) {
		var a = a_.tag.html().toLowerCase();
		var b = b_.tag.html().toLowerCase();
		if (a == b) return 0;
		return (a > b) ? 1: -1;
	});
}

function SortAmount() {
	DoSort(function(a_, b_) {
		var a = parseFloat(a_.meta.find(".rawTotal").html());
		var b = parseFloat(b_.meta.find(".rawTotal").html());
		if (a < 0) a *= -1;
		if (b < 0) b *= -1;
		if (a == b) return 0;
		return (a > b) ? -1: 1;
	});
}

function SortBy( selected ) {
	if (0 == selected)
		SortAlphabetically();
	else if (1 == selected)
		SortFrequency();
	else
		SortAmount();
}
