/* --------------------------- INTUIT CONFIDENTIAL ---------------------------

	tablesorterParsers.js

	Written by		Date 
	Jason Harris	06/06/09
	
	Revised by		Date		Summary of changes
	Lane Roathe		06/17/10	[DE1026] Save and restore table states (for now, just sorted columns)
	Lane Roathe		06/22/10	[DE1411] check window.viewController usage to fix deferred printing
								(Some reports do not have a viewController or attached method)
	Lane Roathe		07/19/10	[DE1456] update sort state retrieval to use new API that accepts default (ie, value if no state yet stored)
	Mickey Roberson	08/25/10	[DE1429] Added a parser that ignores the leading actuator tag in expandable rows
	Lane Roathe		09/21/10	[DE1673] added a multi-table sort init that will sort all matching tables on a column header click
	Chris Campbell	06/16/11	[DE2111] Changing the qPrependedActuator parser so that it lowercases the string before
									returning it (to perform case-insensitive sorting).

	Copyright 2009-2010 Intuit, Inc All rights reserved. Unauthorized
	reproduction is a violation of applicable law. This material contains
	certain confidential and proprietary information and trade secrets of
	Intuit, Inc.
		
	RESTRICTED RIGHTS LEGEND
		
	Use, duplication, or disclosure by the Government is subject to
	restrictions as set forth in subdivision (b) (3) (ii) of the Rights in
	Technical Data and Computer Software clause at 52.227-7013.
		
	Intuit, Inc
	P.O. Box 7850
	Mountain View, CA 94039-7850

----------------------------- INTUIT CONFIDENTIAL ------------------------- */

$.tablesorter.addParser({
	//setauniqueid
	id:'qPrependedActuator',
	is:function(s){
		return false;
	},
	format:function(s){
		var pattern = /<[a-z\s="]*>.*<\/[a-z]*>/;	//"
		var result = s.replace(pattern, "").toLowerCase();
		return result;
	},
	//settype,eithernumericortext
	type:'text'
});


$.tablesorter.addParser({
	//setauniqueid
	id:'qCurrency',
	is:function(s){
			return false;
	},
	format:function(s){
			var result = s.replace(new RegExp(/^(\(?-?)([£$€¥]|([A-Za-z][A-Za-z][A-Za-z] *))([0-9,.]+)\)?$/), "$1$4");
			result = result.replace(',', '');
			result = result.replace('(', '-');
			result = result.replace(' ↑', '');
			result = result.replace(' ↓', '');
			result = $.tablesorter.formatFloat(result);
			return result;
	},
	//settype,eithernumericortext
	type:'numeric'
});

$.tablesorter.addParser({
	//setauniqueid
	id:'qFormattedNumeric',
	is:function(s){
			return false;
	},
	format:function(s){
			var pattern = /[^\deE .-]+/;
			while(1)
			{
				var pos = s.search(new RegExp(pattern));
				if (-1 == pos) break;
				s = s.slice(0, pos).concat(s.slice(pos + 1, s.length));
			}
			s = $.tablesorter.formatFloat(s);
			return s;
	},
	//settype,eithernumericortext
	type:'numeric'
});

$.tablesorter.addParser({
	//setauniqueid
	id:'day-us',
	is:function(s){
			return false;
	},
	format:function(s){
			var pattern = /^(\d{1,2})\/(\d{1,2})\/(\d{4}|\d{2})$/;
			var r = s.match(pattern);
			if (!r) return 0;
			var yr_num = 2000 + parseInt(r[3], 10);
			var mo_num = parseInt(r[1],10)-1;
			var day_num = parseInt(r[2], 10);
			return new Date(yr_num, mo_num, day_num, 0, 0, 0, 0).getTime();
		},
	//settype,eithernumericortext
	type:'numeric'
});

$.tablesorter.addParser({
	//setauniqueid
	id:'day-eu',
	is:function(s){
			return false;
	},
	format:function(s){
			var pattern = /^(\d{1,2})\/(\d{1,2})\/(\d{1,2})$/;
			var r = s.match(pattern);
			if (!r) return 0;
			var yr_num = 2000 + parseInt(r[3], 10);
			var mo_num = parseInt(r[2],10)-1;
			var day_num = parseInt(r[1], 10);
			return new Date(yr_num, mo_num, day_num, 0, 0, 0, 0).getTime();
		},
	//settype,eithernumericortext
	type:'numeric'
});

function InitSortTable(table) {
	var sortState = "[[0,0]]";
	if( window.viewController && window.viewController.TableState )
		sortState = ( window.viewController.TableState( table[0].className, sortState ) );

	table.tablesorter({
		sortList:	JSON.parse( sortState ),
		cssHeader:	"sortcol", 
		cssAsc:		"sortasc", 
		cssDesc:	"sortdesc",
//			debug: 		true
	});
}

var handlingClick = false;

function ClickTableColumn(selector, clickedTable) {
	if( !handlingClick )
	{
		handlingClick = true;

		var tables = $(selector);
		for (var i = 0; i < tables.length; ++i)
		{
			var table = $(tables[i]);
			if( table[0] != clickedTable )
				table.trigger("sorton",[clickedTable.config.sortList]);
		}
		handlingClick = false;
	}
}

function TableSortInit(selector) {
	var tables = $(selector);
	for (var i = 0; i < tables.length; ++i)
	{
		var table = $(tables[i]);
		InitSortTable(table);

		if( window.viewController )
			table.bind("sortBeg",function() {
				   window.viewController.SetTableState( this.className, JSON.stringify( this.config.sortList ) ); 
			});
	}
}

function MultiTableSortInit(selector) {
	var tables = $(selector);
	for (var i = 0; i < tables.length; ++i)
	{
		var table = $(tables[i]);
		InitSortTable(table);

		table.bind("sortBeg",function() {
			if( !handlingClick )
			{
				ClickTableColumn(selector, this);
				if( window.viewController )
					   window.viewController.SetTableState( this.className, JSON.stringify( this.config.sortList ) );
			}
		});
	}
}
