/* --------------------------- INTUIT CONFIDENTIAL ---------------------------
 
 barOrLinePlot.js
 
 Written by		Date
 Jason Harris	08/06/10
 
 Revised by		Date		Summary of changes
 Mickey Roberson	08/17/10	Added support for multi-length x-labels
 Mickey Roberson	10/18/10	[DE1848] Added subtitle support
 
 Copyright 2010 Intuit, Inc All rights reserved. Unauthorized
 reproduction is a violation of applicable law. This material contains
 certain confidential and proprietary information and trade secrets of
 Intuit, Inc.
 
 RESTRICTED RIGHTS LEGEND
 
 Use, duplication, or disclosure by the Government is subject to
 restrictions as set forth in subdivision (b) (3) (ii) of the Rights in
 Technical Data and Computer Software clause at 52.227-7013.
 
 Intuit, Inc
 P.O. Box 7850
 Mountain View, CA 94039-7850
 
 ----------------------------- INTUIT CONFIDENTIAL ------------------------- */

function BarOrLinePlotInit() {
    var plotData = [];
    var plotDataList = $(".plotData");
    var plotDataListElements = plotDataList.find("li");
    for (i = 0; i < plotDataListElements.length; ++i) {
        var listElement = $(plotDataListElements[i]);
        var humanX = listElement.find(".humanTitle").text();
        var mediumHumanX = listElement.find(".mediumHumanTitle").text();
        var shortHumanX = listElement.find(".shortHumanTitle").text();
        var shortHumanXSubtitle = listElement.find(".shortHumanSubtitle").text();
        var rawY = listElement.find(".rawValue").text();
        var humanY = listElement.find(".humanValue").text();
        var transactionCount = listElement.find(".transactionCount").text();
        var entry = {humanX: humanX, mediumHumanX: mediumHumanX, shortHumanX: shortHumanX, shortHumanXSubtitle: shortHumanXSubtitle, y: rawY, humanY: humanY, transactionCount: transactionCount};
        plotData.push(entry);
    }
    plotDataList.hide();
    CreateColumnChart(plotData);
}

function CreateColumnChart(plotData) {
    $(function () {
      var shouldAnimate = true;
      if (window.printViewController) {
      // [DE4184] Don't animate the chart when rendering offscreen for printing
      shouldAnimate = false;
      }
      var plotDate = [];
      var plotAmount = [];
      var steps = 0;
      var angle = 0;
      var max =0;
      if(plotData.length> 12)
      {
        steps = Math.round(plotData.length / 12);
      }
      
      for (var i = 0; i < plotData.length; i++) {
        if(steps <= 1){
      var entryX = {x: plotData[i].shortHumanX, show: 1, tooltip: plotData[i].mediumHumanX};
            plotDate.push(entryX);
        }
        else{
            angle = 45;
            var res = plotData[i].mediumHumanX.match(/Jan/gi);
            var month = null;
            var showLabel = 0;
            if(res != null )
            {
                month = plotData[i].mediumHumanX;
                showLabel = 1;
            }
            else
            {
              if(steps <= 2)
              {
                 var res = plotData[i].mediumHumanX.match(/Mar|May|Jul|Sep|Nov/gi);
                 if(res != null)
                 {
                    showLabel = 1;
                 }
              }
              else if(steps <= 3)
               {
                    var res = plotData[i].mediumHumanX.match(/Apr|Jul|Oct/gi);
                        if(res != null)
                    {
                    showLabel = 1;
                    }
               }
              else if(steps <= 4)
              {
                var res = plotData[i].mediumHumanX.match(/Jun/gi);
                if(res != null)
                {
                    showLabel = 1;
                }
             }

              month = plotData[i].shortHumanX;
            }
            var entryX = {x:month , show: showLabel, tooltip: plotData[i].mediumHumanX};
            plotDate.push(entryX);
        }
        if(plotData[i].y > max)
        {
      max = plotData[i].y;
      }
        var entry = {y: parseInt(plotData[i].y), txnCount: parseInt(plotData[i].transactionCount), total: plotData[i].humanY};
        plotAmount.push(entry);
      }   //for
      
      Highcharts.setOptions({
                                chart: {
                                    style: {
                                        fontFamily: '"HelveticaNeue", "Helvetica Neue", Calibri, sans-serif',
                                        color: '#333'
                                    }
                                },
                                lang: {
                                numericSymbols: null //otherwise by default ['k', 'M', 'G', 'T', 'P', 'E']
                                }
                            });
      
      $('.barPlot').highcharts({
                                chart: {
                                    animation: shouldAnimate,
                                    events: {
                                    load:
                                        function(event) {
                                            if(typeof(GraphHasDisplayed)!=="undefined") {
                                                    GraphHasDisplayed();
                                            }
                                        }
                                    },
                                type: 'column'
                                },
                               
                                plotOptions: {
                                    series: {
                                        animation: shouldAnimate
                                    }
                                },
                               
                                title: {
                                text: ''
                                },
                               
                                xAxis: {
                                    categories: plotDate,
                                    gridLineColor: '#ddd',
                                    labels: {
                                        rotation: angle,
                                        staggerLines: 1,
                                        style:{
                                            color: '#969696',
                                            fontSize: '13px'
                                        },
                                        formatter: function () {
                                            if(this.value.show == 1)
                                            {
                                                return this.value.x;
                                            }
                                            return null;
                                        }
                                    }
                                },
                               
                               yAxis: {
                               
                                reversed:true,
                                title: {
                                    text: ''
                                },
                               max: max,
                                labels: {
                                    style:{
                                        color: '#969696',
                                        fontSize: '13px'
                                    }
                                }
                               },
                               
                               legend: {
                                enabled: false
                               },
                               
                               tooltip: {
                                    borderColor:"#ddd",
                                    headerFormat: '<span style="font-size: 14px;color: #333; display: block; text-align: center;">{point.key.tooltip}</span>',
                                    useHTML: true
                               },
                               
                               credits: {
                                    enabled: false
                               },
                               series: [
                                        {
                                            name: 'Spending Amount',
                                            color  : '#40BF75',
                                            negativeColor: '#FF556C',
                                        
                                            tooltip: {
                                                pointFormat: '<div style="font-size: 22px; color: #333; display: block; text-align: center;">{point.total}</div>'
                                                + ' <div style="color: #969696;text-align: center;">{point.txnCount} Transactions</div>',
                                            },
                                            data: plotAmount,
                                            //borderRadiusTopLeft: 4,
                                            //borderRadiusTopRight: 4
                                        }
                                      ]
                               });
      });
}

function NetWorthPlotInit() {
    var plotData = [];
    var plotDataList = $(".plotData");
    var yAxisStartsAtZero = window.viewController ? window.viewController.GetYAxisStartsAtZero() : false;
    var plotDataListElements = plotDataList.find("li");
    for (i = 0; i < plotDataListElements.length; ++i) {
        var listElement = $(plotDataListElements[i]);
        var humanX = listElement.find(".humanTitle").text();
        var mediumHumanX = listElement.find(".mediumHumanTitle").text();
        var shortHumanX = listElement.find(".shortHumanTitle").text();
        var shortHumanXSubtitle = listElement.find(".shortHumanSubtitle").text();
        var rawY = parseFloat(listElement.find(".rawValue").text());
        var humanY = listElement.find(".humanValue").text();
        var transactionCount = listElement.find(".transactionCount").text();
        var entry = {humanX: humanX, mediumHumanX: mediumHumanX, shortHumanX: shortHumanX, shortHumanXSubtitle: shortHumanXSubtitle, y: rawY, humanY: humanY, transactionCount: transactionCount};
        plotData.push(entry);
    }
    plotDataList.hide();
    $('input[name=yAxisStartsAtZero]').prop('checked', yAxisStartsAtZero);
    CreateNetWorthPlot(plotData, yAxisStartsAtZero);
}

function NetWorthToggleYAxisStartsAtZero()
{
    if (window.viewController)
    {
        if (window.viewController.ToggleYAxisStartsAtZero)
        {
            window.viewController.ToggleYAxisStartsAtZero();
        }
    }
    
    NetWorthPlotInit();
}

function applyGradient() {
    
    
    if(typeof(GraphHasDisplayed)!=="undefined") {
        GraphHasDisplayed();
    }
    var threshold = 0,
    colorAbove = '#40BF75',
    colorBelow = '#FF556C';
    
    var series = this.series[0];

    
    var translatedThreshold = series.yAxis.translate(threshold),
    y1 = Math.round(series.yAxis.len - translatedThreshold),
    y2 = y1 + 3;
   
    // Apply gradient to the path
    series.graph.attr({
                      stroke: {
                      linearGradient: [0, y1, 0, y2],
                      stops: [
                              [0, colorAbove],
                              [1, colorBelow]
                              ]
                      }
                      });
    
    
 }

function CreateNetWorthPlot(plotData, yAxisStartsAtZero) {
    $(function () {
      var shouldAnimate = true;
      if (window.printViewController) {
        // [DE4184] Don't animate the chart when rendering offscreen for printing
        shouldAnimate = false;
      }
      var plotDate = [];
      var plotAmount = [];
      var steps = 0;
      var angle = 0;
      var min = 0;
      var max =0;
      if(plotData.length> 12)
      {
        steps = Math.round(plotData.length / 12);
      }
      
      for (var i = 0; i < plotData.length; i++) {
        if(steps <= 1){
      var entryX = {x: plotData[i].shortHumanX, show: 1, tooltip: plotData[i].humanX};
            plotDate.push(entryX);
        }
        else{
            angle = 45;
            var res = plotData[i].mediumHumanX.match(/Jan/gi);
            var month = null;
            var showLabel = 0;
            if(res != null )
            {
                month = plotData[i].mediumHumanX;
                showLabel = 1;
            }
            else
            {
              if(steps <= 2)
              {
                 var res = plotData[i].mediumHumanX.match(/Mar|May|Jul|Sep|Nov/gi);
                 if(res != null)
                 {
                    showLabel = 1;
                 }
              }
              else if(steps <= 3)
               {
                    var res = plotData[i].mediumHumanX.match(/Apr|Jul|Oct/gi);
                        if(res != null)
                    {
                    showLabel = 1;
                    }
               }
              else if(steps <= 4)
              {
                var res = plotData[i].mediumHumanX.match(/Jun/gi);
                if(res != null)
                {
                    showLabel = 1;
                }
             }

              month = plotData[i].shortHumanX;
            }
            var entryX = {x:month , show: showLabel, tooltip: plotData[i].humanX};
            plotDate.push(entryX);
        }
        if(plotData[i].y > max)
        {
      max = plotData[i].y;
      }
        if (plotData[i].y < min)
        {
            min = plotData[i].y;
        }
        var entry = {y: plotData[i].y, tooltip: plotData[i].humanX, total: plotData[i].humanY};
        plotAmount.push(entry);
      }   //for
      
      if (!yAxisStartsAtZero)
      {
            min = null;
      }
                           
      Highcharts.setOptions({
                                chart: {
                                    style: {
                                        fontFamily: '"HelveticaNeue", "Helvetica Neue", Calibri, sans-serif',
                                        color: '#333'
                                    }
                                },
                                lang: {
                                numericSymbols: null //otherwise by default ['k', 'M', 'G', 'T', 'P', 'E']
                                }
                            });
      
      $('.netWorthPlot').highcharts({
                                chart: {
                                    animation: shouldAnimate,
                                    
                                    events: {
                                    load: applyGradient
                                    },
                                    
                                type: 'line'
                                },
                               
                                plotOptions: {
                                    series: {
                                        animation: shouldAnimate,
                                        marker: {
                                        	enabled: false
                                        }
                                    }
                                },
                               
                                title: {
                                text: ''
                                },
                               
                                xAxis: {
                                    categories: plotDate,
                                    gridLineColor: '#ddd',
                                    labels: {
                                        rotation: angle,
                                        staggerLines: 1,
                                        style:{
                                            color: '#969696',
                                            fontSize: '13px'
                                        },
                                        formatter: function () {
                                            if(this.value.show == 1)
                                            {
                                                return this.value.x;
                                            }
                                            return null;
                                        }
                                    }
                                },
                               
                               yAxis: {                               
                                title: {
                                    text: ''
                                },
                               min: min,
                               max: max,
                                labels: {
                                    style:{
                                        color: '#969696',
                                        fontSize: '13px'
                                    }
                                }
                               },
                               
                               legend: {
                                enabled: false
                               },
                               
                               tooltip: {
                                    borderColor:"#ddd",
                                    headerFormat: '<span style="font-size: 14px;color: #969696; display: block; text-align: center;">{point.key.tooltip}</span>',
                                    useHTML: true
                               },
                               
                               credits: {
                                    enabled: false
                               },
                               series: [
                                        {
                                            name: 'Networth',
                                            tooltip: {
                                                pointFormat: '<div style="font-size: 22px; color: #333; display: block; text-align: center;">{point.total}</div>',
                                            },
                                            data: plotAmount
                                        }
                                      ]
                               });
      });
}
